import java.awt.*;
import java.io.PrintStream;


/**
 * This class shall display reasonable contents while the simulation is running and
 * afterwards it displays the 2D-colored plot of the vehicle distribution
 * @author B.Dring
 * @author S.Holst
 */
public class SolutionCanvas extends Canvas
{

    public SolutionCanvas()
    {
        count = 0;
    }

    public Image getImage()
    {
        return img;
    }

    public Dimension getMinimumSize()
    {
        return new Dimension(400, 500);
    }

    public boolean imageUpdate(Image image, int i, int j, int k, int l, int i1)
    {
        System.out.println("Updating Image" + count++);
        return super.imageUpdate(image, i, j, k, l, i1);
    }

    public boolean mouseMove(Event event, int i, int j)
    {
        System.out.println(j);
        return super.mouseMove(event, i, j);
    }

    public void paint(Graphics g)
    {
        int i = getSize().width;
        int j = getSize().height;
        System.out.println("PAinting");
        if(g != null)
            if(img == null)
            {
                super.paint(g);
                g.setColor(Color.black);
                FontMetrics fontmetrics = g.getFontMetrics();
                int k = (i - fontmetrics.stringWidth(calcString)) / 2;
                int l = j / 2;
                g.drawString(calcString, k, l);
            } else
            {
                g.drawImage(img, 0, 0, i, j, this);
            }
    }

    public void setImage(Image image)
    {
        img = image;
        paint(getGraphics());
    }

    public void update(Graphics g)
    {
        paint(g);
    }

    Image img;
    static String calcString = "Calculating...";
    int count;

}
