import java.awt.*;
import java.awt.image.MemoryImageSource;
import java.io.PrintStream;

/**
 * This class represents the colorbar that explains the picture on the right
 * @author B.Dring
 * @author S.Holst
 */
public class LegendPanel extends Panel
{

    public LegendPanel()
    {
        pix = new int[2400];
        vals = new double[400];
        sc2 = new SolutionCanvas();
        for(int i = 0; i < 400; i++)
            vals[i] = 1.0D - (double)i / 399D;

        LinearColorTransform linearcolortransform = new LinearColorTransform(0.0D, 1.0D);
        Object obj = linearcolortransform.toColor(vals);
        System.out.println(((int[])obj).length);
        int j = 0;
        for(int k = 0; k < 400; k++)
        {
            pix[j] = pix[j + 1] = pix[j + 2] = pix[j + 3] = pix[j + 4] = pix[j + 5] = ((int[])obj)[k];
            j += 6;
        }

        add(new Label("max(Dichte)", 1));
        add(sc2);
        add(new Label("min(Dichte)", 1));
    }

    public Dimension getMinimumSize()
    {
        return new Dimension(80, 180);
    }

    public Dimension getPreferredSize()
    {
        return getMinimumSize();
    }

    void initLegend()
    {
        MemoryImageSource memoryimagesource = new MemoryImageSource(6, 400, pix, 0, 6);
        memoryimagesource.setAnimated(true);
        sc2.setImage(createImage(memoryimagesource));
        sc2.setSize(new Dimension(20, 120));
        memoryimagesource.newPixels();
    }

    public static void main(String args[])
    {
        Frame frame = new Frame();
        LegendPanel legendpanel = new LegendPanel();
        frame.add(legendpanel);
        frame.pack();
        frame.setVisible(true);
        legendpanel.initLegend();
    }

    public int pix[];
    double vals[];
    SolutionCanvas sc2;
}
