import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;

/**
 * This class controls the animation on the lower right
 * The value of Geschw. is adjustable from 0 to 100. 
 * @author B.Dring
 * @author S.Holst
 */
public class AnimatedControl extends ControlPanel
    implements Observer
{
    class ButtonListener
        implements ActionListener
    {

        public void actionPerformed(ActionEvent actionevent)
        {
            if(b == 1)
            {
                anim.setSpeed(getSpeedValue());
                if(anim.start())
                {
                    start.setEnabled(false);
                    stop.setEnabled(true);
                }
            }
            if(b == 2)
            {
                anim.stop();
                start.setEnabled(true);
                stop.setEnabled(false);
            }
        }

        private int getSpeedValue()
        {
            try
            {
                return Integer.valueOf(speed.getText()).intValue();
            }
            catch(Exception _ex)
            {
                speed.setText("50");
            }
            return 50;
        }

        private short b;

        ButtonListener(short word0)
        {
            b = word0;
        }
    }


    AnimatedControl(Animation animation)
    {
        anim = animation;
        add(start = new Button("Start"));
        add(stop = new Button("Stop"));
        add(new Label("Geschw. [1..100]", 1));
        add(speed = new TextField("50"));
        start.addActionListener(new ButtonListener((short)1));
        stop.addActionListener(new ButtonListener((short)2));
        start.setEnabled(false);
        animation.addObserver(this);
    }

    public void update(Observable observable, Object obj)
    {
        start.setEnabled(true);
        stop.setEnabled(false);
    }

    private Animation anim;
    private Button start;
    private Button stop;
    private TextField speed;
    private final short START_BUTTON_ID = 1;
    private final short STOP_BUTTON_ID = 2;
    private final short INTERRUPT_BUTTON_ID = 3;




}
