/*HubApplet
Platzierung von 20 Unfallorten in der Ebene und Berechnung der idealen 
Standorte fr drei Rettungshubschrauber. Ideal im Sinne von der minimalen 
Summe der Quadrate der Abstnde (Schwerpunkt).
Die Punkt knnen mit der Maus verschoben und platziert oder zufllig erzeugt werden. 
Danach knnen entweder durch eine Anfangsheuristik oder durch eine zufllige Auswahl 
drei Orte als Standorte ausgewhlt werden. Diese Wahl kann verbessert werden durch die
Buttons Pseudo SP und Korrektur.
Hamburg, 29.10.2003, Tilman Seidel*/
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class HubApplet extends Applet implements ActionListener{
    HubBild tirol;
    double[][] p = new double[20][2];
    double[][] abstandsMatrix = new double[20][20];
    boolean[] pGetroffen = new boolean[20];
    boolean algorithmusFortsetzen = false;
    int[] q = new int[3];
    int[] qVonP = new int[20];
    int breiteX=669;
    int breiteY=429-33;
    public void init(){
	setBackground(new Color(221,221,221));
	tirol = new HubBild(breiteX,breiteY);//neue Zeichenflche
	tirol.addMouseListener(new MyMouseListener());
	tirol.addMouseMotionListener(new MyMouseMotionListener());
	
	setLayout(new BorderLayout());
	add("Center",tirol);
	
	Panel panelUnten = new Panel();
	
	Button neu = new Button("Neu");
	neu.addActionListener(this);
	panelUnten.add(neu);
	Button zufall = new Button("20 Orte");
	zufall.addActionListener(this);
	panelUnten.add(zufall);
	Button anfangsheuristik = new Button("Anfangsheuristik");
	anfangsheuristik.addActionListener(this);
	panelUnten.add(anfangsheuristik);
	anfangsheuristik.setBackground(new Color(190,190,190));
	//	anfangsheuristik.setForeground(new Color(221,221,221));
	Button zAnfang = new Button("3 zufllige Hubschrauber");
	zAnfang.addActionListener(this);
	panelUnten.add(zAnfang);
	zAnfang.setBackground(new Color(190,190,190));
	//	zAnfang.setForeground(new Color(221,221,221));
	Button pSchwerpunkt = new Button("Pseudo-Schwerpunkt");
	pSchwerpunkt.addActionListener(this);
	panelUnten.add(pSchwerpunkt);
	pSchwerpunkt.setBackground(new Color(190,190,190));
	//	pSchwerpunkt.setForeground(new Color(221,221,221));
	Button korrektur = new Button("Korrektur");
	korrektur.addActionListener(this);
	panelUnten.add(korrektur);
	korrektur.setBackground(new Color(190,190,190));
	//	korrektur.setForeground(new Color(221,221,221));

	add("South",panelUnten);
	neustart();
    }
    
    //zufllige Auswahl von drei Hubschr.standorten
    public void zufAnfang(){
	boolean[] punktNochNichtErfasst = new boolean[20];
	boolean[] punktNochNichtGefunden= new boolean[3];
	for(int i=0;i<20;i++){
	    punktNochNichtErfasst[i]=true;
	    if(i<3){
		punktNochNichtGefunden[i]=true;
	    }
	    for(int j=0;j<20;j++){
		abstandsMatrix[i][j]=abstand(p[i][0],p[i][1],p[j][0],p[j][1]);
	    }
	}
	double[] zufall=new double[3];
	zufall[0]=Math.random();
	zufall[1]=Math.random();
	zufall[2]=Math.random();

	/*folgende Schleife ist nicht sehr intelligent,
	  da ich doch fr jeden Fall eine Ausnahme programmiert habe....*/
	for(int j=0;j<3;j++){
	    while(punktNochNichtGefunden[j]){
		for(int i=0;i<20;i++){
		    if(j==0){
			if((zufall[j]>=i*(double)1/20)&(zufall[j]<(i+1)*(double)1/20)){
			    q[j]=i;
			    qVonP[i]=i;
			    punktNochNichtErfasst[i]=false;
			    punktNochNichtGefunden[j]=false;
			}
		    }//if
		    if(j==2){
			if((zufall[j]>=i*(double)1/20)&(zufall[j]<(i+1)*(double)1/20)){
			    if(zufall[j-2]>=i*(double)1/20&(zufall[j-2]<(i+1)*(double)1/20)||
			       (zufall[j-1]>=i*(double)1/20)&zufall[j-1]<(i+1)*(double)1/20){
				    zufall[j]=Math.random();
				    i=99;
			    }
			    else{
				q[j]=i;
				qVonP[i]=i;
				punktNochNichtErfasst[i]=false;
				punktNochNichtGefunden[j]=false;
			    }
			}//if
		    }//if(j==2)
		    if(j==1){
			if(zufall[j]>=i*(double)1/20&(zufall[j]<(i+1)*(double)1/20)){
			    if((zufall[j-1]>=i*(double)1/20)&zufall[j-1]<(i+1)*(double)1/20){
				zufall[j]=Math.random();
				i=99;
			    }
			    else{
				q[j]=i;
				qVonP[i]=i;
				punktNochNichtErfasst[i]=false;
				punktNochNichtGefunden[j]=false;
			    }
			}
		    }//if(j==1)
		}//for i
	    }//while
	}//for j

	//Zuordnung der jetzt noch freien Punkte
	for(int i=0;i<20;i++){
	    if(punktNochNichtErfasst[i]){
		if(abstandsMatrix[q[0]][i]<abstandsMatrix[q[1]][i]&
		   abstandsMatrix[q[0]][i]<abstandsMatrix[q[2]][i]){
		    qVonP[i]=q[0];
		}
		if(abstandsMatrix[q[1]][i]<abstandsMatrix[q[0]][i]&
		   abstandsMatrix[q[1]][i]<abstandsMatrix[q[2]][i]){
		    qVonP[i]=q[1];
		}
		if(abstandsMatrix[q[2]][i]<abstandsMatrix[q[1]][i]&
		   abstandsMatrix[q[2]][i]<abstandsMatrix[q[0]][i]){
		    qVonP[i]=q[2];
		}
	    }
	}
    }

    //Nun der grte Aufwand die Anfangsheuristik:
    public void anfangsHeuristik(){
	int[] kleinsteAbstaende = new int[20];
	double abstandsPuffer;
	int maxAnzahlKreuzePuffer;
	int[] anzahlKreuze = new int[20];
	int indexMaxAnzahlKreuze;
	double[] summeDerKleinstenAbstaende = new double[20];
	double summeDerKleinstenAbstaendePuffer;
	boolean[] punktNochNichtErfasst = new boolean[20];
	
	for(int i=0;i<20;i++){
	    punktNochNichtErfasst[i]=true;
	}
	
	for(int hubi=0;hubi<3;hubi++){
	    maxAnzahlKreuzePuffer=0;
	    indexMaxAnzahlKreuze=0;
	    summeDerKleinstenAbstaendePuffer=abstand(0,0,breiteX,breiteY);
	    for(int i=0;i<20;i++){
		summeDerKleinstenAbstaende[i]=0;
	    }
	    
	    //Initialisiere alle Abstaende der Punkte untereinander:
	    for(int i=0;i<20;i++){
		anzahlKreuze[i]=0;
		abstandsPuffer=abstand(0,0,breiteX,breiteY);
		if(punktNochNichtErfasst[i]){
		    for(int j=0;j<20;j++){
			abstandsMatrix[i][j]=abstand(p[i][0],p[i][1],p[j][0],p[j][1]);
			if(abstandsMatrix[i][j]<abstandsPuffer&j!=i){
			    abstandsPuffer=abstandsMatrix[i][j];
			    //Punkt mit dem kleinsten Abstand von Punkt i ist Punkt j:
			    kleinsteAbstaende[i]=j; 
			}
		    }
		}
	    }
	    
	    //Zaehle die Anzahl der Kreuze, d.h. die Anzahl der Punkte i, die als naechsten Punkt
	    //den Punkt j haben und addiere die Abstaende:
	    for(int i=0;i<20;i++){
		if(punktNochNichtErfasst[i]){
		    for(int j=0;j<20;j++){
			if(kleinsteAbstaende[i]==j){
			    anzahlKreuze[j]++;
			    summeDerKleinstenAbstaende[j]+=abstand(p[i][0],p[i][1],p[j][0],p[j][1]);
			}
		    }
		}
	    }
	    
	    /*Bestimme die Zeile mit den meisten Kreuzen, d.h. den Punkt, den am meisten Punkte
	      als naechsten haben;
	      falls es mehrere Zeilen mit der maximalen Anzahl von Kreuzen gibt
	      waehle die aus, in die Summe der kleinsten Abstaende am kleinsten ist.*/
	    for(int i=0;i<20;i++){
		if(punktNochNichtErfasst[i]){
		    if(anzahlKreuze[i]>maxAnzahlKreuzePuffer){
			maxAnzahlKreuzePuffer=anzahlKreuze[i];
			indexMaxAnzahlKreuze=i;
		    }
		    if(anzahlKreuze[i]==maxAnzahlKreuzePuffer&summeDerKleinstenAbstaende[i]<summeDerKleinstenAbstaendePuffer){
			summeDerKleinstenAbstaendePuffer=summeDerKleinstenAbstaende[i];
			indexMaxAnzahlKreuze=i;
		    }
		}
	    }
	    
	    q[hubi]=indexMaxAnzahlKreuze;
	    qVonP[q[hubi]]=q[hubi];
	    punktNochNichtErfasst[indexMaxAnzahlKreuze]=false;
	    for(int i=0;i<20;i++){
		if(punktNochNichtErfasst[i]){
		    qVonP[i]=kleinsteAbstaende[i];
		    if(qVonP[i]==q[hubi]){
			punktNochNichtErfasst[i]=false;
		    }
		}
	    }
	}
	
	//Zuordnung der jetzt noch freien Punkte
	for(int i=0;i<20;i++){
	    if(punktNochNichtErfasst[i]){
		if(abstandsMatrix[q[0]][i]<abstandsMatrix[q[1]][i]&
		   abstandsMatrix[q[0]][i]<abstandsMatrix[q[2]][i]){
		    qVonP[i]=q[0];
		}
		if(abstandsMatrix[q[1]][i]<abstandsMatrix[q[0]][i]&
		   abstandsMatrix[q[1]][i]<abstandsMatrix[q[2]][i]){
		    qVonP[i]=q[1];
		}
		if(abstandsMatrix[q[2]][i]<abstandsMatrix[q[1]][i]&
		   abstandsMatrix[q[2]][i]<abstandsMatrix[q[0]][i]){
		    qVonP[i]=q[2];
		}
	    }
	}
    }

    //Finde jeweils den Schwerpunkt der drei Hubschraubergruppen
    public void pseudoSchwerpunkt(){
	double[] wert = new double[2];
	int anzahl;
	double abstandPuffer;
	int hubiPuffer=0;
	for(int hubi=0;hubi<3;hubi++){
	    wert[0]=0;
	    wert[1]=0;
	    anzahl=0;
	    abstandPuffer=abstand(0,0,breiteX,breiteY);
	    for(int i=0;i<20;i++){
		if(qVonP[i]==q[hubi]){
		    anzahl++;
		}
	    }
	    for(int i=0;i<20;i++){
		if(qVonP[i]==q[hubi]){
		    wert[0]+=p[i][0]/anzahl;
		    wert[1]+=p[i][1]/anzahl;
		}
	    }
	    for(int i=0;i<20;i++){
		if(qVonP[i]==q[hubi]){
		    if(abstand(p[i][0],p[i][1],wert[0],wert[1])<abstandPuffer){
			abstandPuffer=abstand(p[i][0],p[i][1],wert[0],wert[1]);
			hubiPuffer=i;
		    }
		}
	    }
	    for(int i=0;i<20;i++){
		if(qVonP[i]==q[hubi]){
		    qVonP[i]=hubiPuffer;
		} 
	    }
	    q[hubi]=hubiPuffer;
	}
    }
    
    //berprfe die Abstnde zu den drei Hubschr.
    //und korrigiere ggf. die zugehrigkeit (qVonP)
    public void korrigieren(){
	for(int i=0;i<20;i++){
	    for(int j=0;j<3;j++){
		if(abstandsMatrix[i][q[j]]<abstandsMatrix[i][qVonP[i]]){
		    qVonP[i]=q[j];
		}
	    }
	}
    }

    //bergabe der Daten zum Zeichnen an das Objekt tirol
    public void infosUebergeben(){
	for(int i=0;i<tirol.punkteZaehler;i++){
	    tirol.p[i][0]=p[i][0];
	    tirol.p[i][1]=p[i][1];
	}
	for(int i=0;i<20;i++){
	    tirol.farbe[i]=0;
	}
	for(int i=0;i<20;i++){
	    tirol.hubOderNicht[i]=false;
	    if(i==q[0]||i==q[1]||i==q[2]){
		tirol.hubOderNicht[i]=true;
	    }
	    if(qVonP[i]==q[0]||i==q[0]){
		tirol.farbe[i]=1;
	    }
	    if(qVonP[i]==q[1]||i==q[1]){
		tirol.farbe[i]=2;
	    }
	    if(qVonP[i]==q[2]||i==q[2]){
		tirol.farbe[i]=3;
	    }
	}
	tirol.quadratsumme=quadratSumme();
	tirol.repaint();
    }

    //bergabe der Daten zum Zeichnen im Falle der Neuauswahl von Orten
    public void neustart(){
	tirol.punkteZaehler=0;
	for(int i=0;i<20;i++){
	    tirol.farbe[i]=0;
	    tirol.hubOderNicht[i]=false;
	}
	algorithmusFortsetzen=false;
	tirol.quadratsumme=0;
	tirol.repaint();
    }

    //Button-Aktionen
    public void actionPerformed(ActionEvent event){
	if(event.getActionCommand().equals("Neu")){
	    neustart();
	}
	if(event.getActionCommand().equals("20 Orte")){
	    tirol.punkteZaehler=0;
	    for(int i=0;i<20;i++){
		p[i][0]=Math.round((breiteX-30)*Math.random())+15;
		p[i][1]=Math.round((breiteY-30)*Math.random())+15;
		tirol.punkteZaehler++;
	    }
	    for(int i=0;i<tirol.punkteZaehler;i++){
		tirol.p[i][0]=p[i][0];
		tirol.p[i][1]=p[i][1];
		tirol.farbe[i]=0;
		tirol.hubOderNicht[i]=false;
	    }
	    tirol.quadratsumme=0;
	    tirol.repaint();
	}
	if(event.getActionCommand().equals("Anfangsheuristik")){
	    anfangsHeuristik();
	    if(tirol.punkteZaehler==20){
		algorithmusFortsetzen=true;
	    }
	    infosUebergeben();
	}
	if(event.getActionCommand().equals("3 zufllige Hubschrauber")){
	    zufAnfang();
	    if(tirol.punkteZaehler==20){
		algorithmusFortsetzen=true;
	    }
	    infosUebergeben();
	}
	if(event.getActionCommand().equals("Pseudo-Schwerpunkt")&algorithmusFortsetzen){
	    pseudoSchwerpunkt();
	    infosUebergeben();
	}
	if(event.getActionCommand().equals("Korrektur")&algorithmusFortsetzen){
	    korrigieren();
	    infosUebergeben();
	}
    }    
    
    
    public double abstand(double x0,double x1,double y0,double y1){
	return Math.sqrt((x0-y0)*(x0-y0)+(x1-y1)*(x1-y1));
    }

    public double quadratSumme(){
	double wert=0;
	for(int i=0;i<20;i++){
	    wert+=abstand(p[i][0],p[i][1],p[qVonP[i]][0],p[qVonP[i]][1])*
		abstand(p[i][0],p[i][1],p[qVonP[i]][0],p[qVonP[i]][1]);
	}
	return wert;
    }

    class MyMouseListener extends MouseAdapter
    {
	public void mousePressed(MouseEvent event){
	    boolean punktOderNicht=true;
	    if(event.isMetaDown()==false){
		for(int i=0;i<tirol.punkteZaehler;i++){
		    pGetroffen[i]=false;
		    if(abstand(p[i][0],p[i][1],event.getX(),event.getY())<5&!algorithmusFortsetzen){
			pGetroffen[i]=true;
			punktOderNicht=false;
		    }
		}
		if(punktOderNicht){
		    p[tirol.punkteZaehler][0]=event.getX();
		    p[tirol.punkteZaehler][1]=event.getY();
		    tirol.punkteZaehler++;
		}
	    }
	    for(int i=0;i<tirol.punkteZaehler;i++){
		tirol.p[i][0]=p[i][0];
		tirol.p[i][1]=p[i][1];
	    }
	    tirol.quadratsumme=0;
	    tirol.repaint();
	}
    }

    class MyMouseMotionListener extends MouseMotionAdapter{
	public void mouseDragged(MouseEvent event){
	    for(int i=0;i<tirol.punkteZaehler;i++){
		if(pGetroffen[i]&!algorithmusFortsetzen){
		    p[i][0]=event.getX();
		    p[i][1]=event.getY();
		    tirol.p[i][0]=p[i][0];
		    tirol.p[i][1]=p[i][1];
		    tirol.quadratsumme=0;
		    tirol.repaint();
		    i=99;
		}
	    }
	}
    }

}
