/*DreieckApplet*/
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class DreieckApplet extends Applet implements ActionListener {
	GraphDreieck dreieck;
	boolean[] eckeGetroffen;
	Panel hilfslinienPanel = new Panel();
	public void init() {
		setLayout(new BorderLayout());
		eckeGetroffen = new boolean[3];
		for (int i = 0; i < 3; i++) {
			eckeGetroffen[i] = false;
		}
		dreieck = new GraphDreieck(669, 429, 50, 50, 50, 300, 250, 100);

		dreieck.addMouseListener(new MyMouseListener());
		dreieck.addMouseMotionListener(new MyMouseMotionListener());
		add("Center", dreieck);

		Button cavalieriKreise = new Button("Hilfskreise fr Cavalieri-Pkt.");
		cavalieriKreise.addActionListener(this);
		Button schwerpunktLinien = new Button("Seitenhalbierende fr Schwerpunkt");
		schwerpunktLinien.addActionListener(this);
		Button umkreisLinien = new Button("Mittelsenkrechte und Umkreis");
		umkreisLinien.addActionListener(this);
		hilfslinienPanel.add(cavalieriKreise);
		hilfslinienPanel.add(schwerpunktLinien);
		hilfslinienPanel.add(umkreisLinien);
		add("South", hilfslinienPanel);
	}

	public void actionPerformed(ActionEvent event) {
		if (event.getActionCommand().equals("Hilfskreise fr Cavalieri-Pkt.")) {
			dreieck.cavalierihilfeZeichnen();
		} else if (
			event.getActionCommand().equals("Seitenhalbierende fr Schwerpunkt")) {
			dreieck.seitenhalbierendeZeichnen();
		} else if (event.getActionCommand().equals("Mittelsenkrechte und Umkreis")) {
			dreieck.mittelsenkrechteZeichnen();
		}
		dreieck.repaint();
	}
	public double abstand(double x0, double x1, double y0, double y1) {
		return Math.sqrt((x0 - y0) * (x0 - y0) + (x1 - y1) * (x1 - y1));
	}

	class MyMouseListener extends MouseAdapter {
		public void mousePressed(MouseEvent event) {
			if (event.isMetaDown() == false) {
				for (int i = 0; i < 3; i++) {
					eckeGetroffen[i] = false;
					if (abstand(dreieck.ecke[i][0],
						dreieck.ecke[i][1],
						event.getX(),
						event.getY())
						< 10) {
						eckeGetroffen[i] = true;
					}
				}
			}
		}
	}

	class MyMouseMotionListener extends MouseMotionAdapter {
		public void mouseDragged(MouseEvent event) {
			for (int i = 0; i < 3; i++) {
				if (eckeGetroffen[i]) {
					if (event.getX()
						> 0 & event.getX()
						< 669 & event.getY()
						> 0 & event.getY()
						< 400) {
						dreieck.ecke[i][0] = event.getX();
						dreieck.ecke[i][1] = event.getY();
						dreieck.repaint();
					}
				}
			}
		}
	}

}
