/*DreieckApplet*/
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class DreieckApplet extends Applet implements ActionListener{
    GraphDreieck dreieck;
    boolean[] eckeGetroffen;
    public void init(){
	setLayout(new BorderLayout());
	eckeGetroffen = new boolean[3];
	for(int i=0;i<3;i++){
	    eckeGetroffen[i]=false;
	}
	dreieck = new GraphDreieck(669,429,50,50,50,300,250,100);
	
	dreieck.addMouseListener(new MyMouseListener());
	dreieck.addMouseMotionListener(new MyMouseMotionListener());
	add("Center",dreieck);
	
	Button hilfslinien = new Button("Hilfslinien");
	hilfslinien.addActionListener(this);
	add("South",hilfslinien);
    }
    
    public void actionPerformed(ActionEvent event){
	if(event.getActionCommand().equals("Hilfslinien")){
	    if(dreieck.hilfslinien){
		dreieck.hilfslinien=false;
	    }
	    else{
		dreieck.hilfslinien=true;
	    }
	    dreieck.repaint();
	}
    }
    public double abstand(double x0,double x1,double y0,double y1){
	return Math.sqrt((x0-y0)*(x0-y0)+(x1-y1)*(x1-y1));
    }
    
    class MyMouseListener extends MouseAdapter
    {
	public void mousePressed(MouseEvent event){
	    if(event.isMetaDown()==false){
		for(int i=0;i<3;i++){
		    eckeGetroffen[i]=false;
		    if(abstand(dreieck.ecke[i][0],dreieck.ecke[i][1],event.getX(),event.getY())<10){
			eckeGetroffen[i]=true;
		    }
		}
	    }
	}
    }
    
    class MyMouseMotionListener extends MouseMotionAdapter{
	public void mouseDragged(MouseEvent event){
	    for(int i=0;i<3;i++){
		if(eckeGetroffen[i]){
		    dreieck.ecke[i][0]=event.getX();
		    dreieck.ecke[i][1]=event.getY();
		    dreieck.repaint();
		}
	    }
	}
    }
    
}
